<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\Verifikasis_p_manager;
use Illuminate\Support\Facades\DB;



class Report_pController extends Controller {



    public function index() {
      $verifikasis_p_manager = DB::table('verifikasi_pengunjung_manager')->paginate(10);
      
        return view('verifikasiPengunjungManager.index',['verifikasis_p_manager' => $verifikasis_p_manager]);
    }


      public function create()
    {
       return view('verifikasiPengunjungManager.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $verifikasi_p = new verifikasis_p_manager;
        $verifikasi_p->nama = $request->nama;
        $verifikasi_p->save();
        return redirect()->route('verifikasiPengunjungManager.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis_p_manager'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis_p_manager();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->status = 'request';
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasiPengunjungManager');
      } else {
        return Redirect::to('verifikasiPengunjungManager')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasi_p = verifikasis_p_manager::findOrFail($id);
        $verifikasi_p->delete();
        return redirect()->route('verifikasiPengunjungManager.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 