<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\UpLoadrk;

use DB;

class UploadrkController extends Controller {



    public function index() {
      
      $uploadrk = DB::table('laporanKeuanganReceptionist')->paginate(10);
        return view('laporanKeuanganReceptionist.index',['uploadrk' => $uploadrk]);
    }


      public function create()
    {
       return view('laporanKeuanganReceptionist.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $laporanKeuanganReceptionist = new uploadrk;
        $laporanKeuanganReceptionist->nama = $request->nama;
        $laporanKeuanganReceptionist->save();
        return redirect()->route('laporanKeuanganReceptionist.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'uploadrk'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new uploadrk();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('laporanKeuanganReceptionist');
      } else {
        return Redirect::to('laporanKeuanganReceptionist')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $laporanKeuanganReceptionist = Uploadrk::findOrFail($id);
        $laporanKeuanganReceptionist->delete();
        return redirect()->route('laporanKeuanganReceptionist.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 