<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Validator;
use Response;
use Redirect;
use Session;
use App\Verifikasis;
use Illuminate\Support\Facades\DB;



class VerifikasisController extends Controller {



    public function index() {
      $verifikasis = DB::table('verifikasi')->paginate(10);
      
        return view('verifikasi.index',['verifikasis' => $verifikasis]);
    }


      public function create()
    {
       return view('verifikasi.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,['nama'=> 'required',]);

        $verifikasi = new verifikasis;
        $verifikasi->nama = $request->nama;
        $verifikasi->save();
        return redirect()->route('verifikasi.index')->with('alert-success','Data Hasbeen Saved');
    }


    public function multiple_upload() {
      // getting all of the post data
      $files = Input::file('images');
      // Making counting of uploaded images
      $file_count = count($files);
      // start count how many uploaded
      $uploadcount = 0;

      foreach ($files as $file) {
        $rules = array('file' => 'required'); //'required|mimes:png,gif,jpeg,txt,pdf,doc'
        $validator = Validator::make(array('file'=> $file), $rules);
        if($validator->passes()){
          $destinationPath = 'verifikasis'; // upload folder in public directory
          $filename = $file->getClientOriginalName();
          $upload_success = $file->move($destinationPath, $filename);
          $uploadcount ++;

          // save into database
          $extension = $file->getClientOriginalExtension();
          $entry = new verifikasis();
          $entry->mime = $file->getClientMimeType();
          $entry->original_filename = $filename;
          $entry->filename = $file->getFilename().'.'.$extension;
          $entry->save();
        }
      }
      if($uploadcount == $file_count){
        Session::flash('success', 'Upload successfully');
        return Redirect::to('verifikasi');
      } else {
        return Redirect::to('verifikasi')->withInput()->withErrors($validator);
      }
    }


     public function destroy($id)
    {
         $verifikasi = Verifikasis::findOrFail($id);
        $verifikasi->delete();
        return redirect()->route('verifikasi.index')->with('alert-success','Data Hasbeen Deleted');  
    }



} 