<?php

namespace App\Http\Controllers\backend;

use Illuminate\Http\Request;

use App\Http\Requests\reqPgw;
use App\Http\Controllers\Controller;

use App\Models\Pegawai;

use App\User;

class PgwCtrl extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $this->data['title'] = 'Data pegawai';
        $this->data['pegawai'] = Pegawai::orderBy('nip')->paginate(15);
        return view('backend.pegawai.index',$this->data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $this->data['title'] = 'Tambah Data pegawai';
       
        $this->data['jabatan'] = ['Pegawai'];
       
        return view('backend.pegawai.create',$this->data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(reqPgw $request)
    {
        //
        $input = $request->all();
        $input['user_id'] = User::create(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'pegawai'])->id;
        Pegawai::create($input);
        return redirect()->route('pegawai.index')->with('info','pegawai Berhasil Ditambahkan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $this->data['title'] = 'Edit Data pegawai';
        $this->data['pegawai'] = Pegawai::find($id);
       
        $this->data['jabatan'] = ['Pegawai'];
       
        return view('backend.pegawai.edit',$this->data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $input = $request->except('_method','_token','mhs_id');
        $mhs = Pegawai::find($id);
        $mhs->update($input);
        $input['user_id'] = User::find($mhs->user_id)->update(['username' => $input['nip'],'password' => bcrypt($input['nip']),'role' => 'pegawai']);
        return redirect()->route('pegawai.index')->with('info','Data pegawai berhasil diubah');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $nilai = Pegawai::find($id);
        $nilai->delete();
        return redirect()->route('pegawai.index')->with('info','Data pegawai berhasil dihapus');
    }
}
