<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class reqPgw extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {

        return [
            //
            'nip' => 'required|unique:tbl_pegawai,nip,'.$request->input('mhs_id'),
            'tahun_masuk' => 'required|date_format:"Y"',
            'nama_pegawai' => 'required'
        ];
    }

    public function messages(){
        return [
            'nip.required' => 'NIP harus diisi',
            'nip.unique' => 'NIP sudah terdaftar',
            'tahun_masuk.required' => 'tahun_masuk harus diisi',
            'tahun_masuk.date_format' => 'Format tahun_masuk harus berupa tahun',
            'nama_pegawai.required' => 'Nama pegawai harus diisi'

        ];
    }
}
