package com.example.login.Home

import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import android.widget.ImageView
import android.widget.TextView
import com.example.login.Adapter.AdapterBph
import com.example.login.Adapter.AdapterMahasiswa
import com.example.login.Api.API
import com.example.login.Api.Common
import com.example.login.Model.Mahasiswa
import com.example.login.Model.BphModel

import com.example.login.R
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response


class BphActivity : AppCompatActivity() {

    lateinit var bph:RecyclerView

    lateinit var mService: API
    lateinit var layoutManager: LinearLayoutManager
    lateinit var adapterBph: AdapterBph


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_bph)
        bph = findViewById(R.id.bph)
        bph.setHasFixedSize(true)
        layoutManager = LinearLayoutManager(applicationContext)
        bph.layoutManager = layoutManager

        mService = Common.retrofitService

        getallbph()
    }

    private fun getallbph() {
        mService.getbph().enqueue(object : Callback<MutableList<BphModel>>{
            override fun onFailure(call: Call<MutableList<BphModel>>, t: Throwable) {
                print("Error : "+t.toString())
            }

            override fun onResponse(call: Call<MutableList<BphModel>>, response: Response<MutableList<BphModel>>) {
                try {
                    if (response!=null){
                        print( "Data : "+response.body())
                        adapterBph = AdapterBph(applicationContext, response.body() as MutableList<BphModel>)
                        adapterBph.notifyDataSetChanged()
                        bph.adapter = adapterBph
                    }
                }
                catch (t : ExceptionInInitializerError){
                    print( "Data : "+t.message)
                }
            }

        })
    }
}

