package com.example.login.Home.KegiatanFragment

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import com.example.login.Adapter.AdapterKegiatan
import com.example.login.Api.API
import com.example.login.Api.Common
import com.example.login.Model.Kegiatan

import com.example.login.R
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response


class KegiatanFragment : Fragment() {

    lateinit var sada:RecyclerView

    lateinit var mService: API
    lateinit var layoutManager: LinearLayoutManager
    lateinit var adapterKegiatan: AdapterKegiatan

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        // Inflate the layout for this fragment
        var view= inflater.inflate(R.layout.fragment_kegiatan, container, false)
        sada = view.findViewById(R.id.sada)
        sada.setHasFixedSize(true)
        layoutManager = LinearLayoutManager(context)
        sada.layoutManager = layoutManager

        mService = Common.retrofitService

        getallkegiatan()
        return view
    }

    private fun getallkegiatan() {
        mService.getkegiatan().enqueue(object : Callback<MutableList<Kegiatan>>{
            override fun onFailure(call: Call<MutableList<Kegiatan>>, t: Throwable) {
                print("Error : "+t.toString())
            }

            override fun onResponse(call: Call<MutableList<Kegiatan>>, response: Response<MutableList<Kegiatan>>) {
                try {
                    if (response!=null){
                        print( "Data : "+response.body())
                        adapterKegiatan = AdapterKegiatan(context, response.body() as MutableList<Kegiatan>)
                        adapterKegiatan.notifyDataSetChanged()
                        sada.adapter = adapterKegiatan
                    }
                }
                catch (t : ExceptionInInitializerError){
                    print( "Data : "+t.message)
                }
            }

        })
    }


}
