Yii とは何か
============

Yii は現代的なウェブアプリケーションを迅速に開発するための、高性能な、コンポーネントベースの PHP フレームワークです。
Yii という名前 (`イー` すなわち `[ji:]` と発音します) は、中国語では「易」であり、「シンプルかつ進化的」であることを意味します。
また **Yes It Is** のアクロニム(頭字語)であると考えることも出来ます。


Yii は何に向いているか
----------------------

Yii は汎用的なウェブプログラミングフレームワークです。
つまり、あらゆる種類のウェブアプリケーションを PHP を使って開発するときに、Yii を使用することが出来ます。
コンポーネントベースのアーキテクチャと洗練されたキャッシュサポートを持っているため、Yii は大規模なアプリケーション、たとえば、ポータル、フォーラム、コンテンツマネージメントシステム (CMS)、電子商取引プロジェクト、RESTful ウェブサービス、等々を開発するのに特に適しています。


Yii を他のフレームワークと比べるとどうか?
-----------------------------------------

あなたが既に他のフレームワークに親しんでいる場合は、Yii を比較するとどうなるのかを知りたいと思うでしょう。

- ほとんどの PHP フレームワーク同様、Yii は MVC (Model-View-Controller) デザインパターンを実装し、このパターンに基づいたコードの組織化を推進しています。
- Yii は、コードはシンプルかつエレガントに書かれるべきである、という哲学を採用しています。
  Yii は、何らかのデザインパターンを厳密に守ることを主たる目的として大袈裟な設計をすることは、決してしようとしません。
- Yii は、検証済みで直ちに使える多数の機能を提供するフル装備のフレームワークです。
  リレーショナルデータベースと NoSQL データベースの両方のためのクエリビルダとアクティブレコード、RESTful API 開発サポート、多層構成のキャッシュサポート、その他諸々。
- Yii は極めて拡張性の高いフレームワークです。あなたはコアのコードのほとんど全ての要素をカスタマイズしたり置き換えたりすることが出来ます。
  また、Yii の堅固なエクステンションアーキテクチャを利用して、再配布可能なエクステンションを使用したり開発したりすることも出来ます。
- 高性能であることは常に Yii の主たる目標です。

Yii はワンマンショーではありません。Yii は [強力なコア開発チーム][] および Yii 開発に間断なく貢献してくれるプロフェッショナルの大きなコミュニティーに支えられたプロジェクトです。
Yii 開発チームは最新のウェブ開発の潮流や、他のフレームワークやプロジェクトに見られる最善の慣行と機能から目を離しません。
他のところで見出された関連性の高い最善の慣行と機能は、定期的にコアフレームワークに組み込まれ、シンプルかつエレガントなインターフェイスを通じて公開されます。

[強力なコア開発チーム]: http://www.yiiframework.com/about/

Yii のバージョン
----------------

Yii は現在、利用可能な二つのメジャーバージョン、すなわち 1.1 と 2.0 を持っています。
バージョン 1.1 は古い世代のもので、現在はメンテナンスモードにあります。
バージョン 2.0 は、最新のテクノロジーとプロトコル、例えば、Composer、PSR、名前空間、トレイトなどを採用して、Yii を完全に書き直したものです。
バージョン 2.0 がこのフレームワークの現世代を表すものであり、今後数年間にわたって主要な開発努力の対象となるものです。
このガイドは主としてバージョン 2.0 について述べます。


必要条件と前提条件
------------------

Yii 2.0 は PHP 5.4.0 以上を必要とします。
個別の機能に対する詳細な必要条件は、全ての Yii リリースに含まれている必要条件チェッカを走らせることによって知ることが出来ます。

Yii を使うためには、オブジェクト指向プログラミング (OOP) の基本的な知識が必要です。
なぜなら、Yii は純粋な OOP ベースのフレームワークだからです。
また、Yii 2.0 は [名前空間](http://php.net/manual/ja/language.namespaces.php) や [トレイト](http://php.net/manual/ja/language.oop5.traits.php) のような PHP の最新の機能を利用しています。
これらの概念を理解することは、Yii 2.0 を採用することをより一層容易にするでしょう。

