Автозавантаження класів
=================
Пошук і підключення файлів класів в Yii реалізовано за допомогою
[автозавантаження класів](http://www.php.net/manual/ru/language.oop5.autoload.php). Фреймворк надає свій швидкий сумісний з [PSR-4](https://github.com/php-fig/fig-standards/blob/master/proposed/psr-4-autoloader/psr-4-autoloader.md)
автозавантажувач, який встановлюється в момент підключення `Yii.php`.

> Примітка: Для простоти оповіді, в цьому розділі ми будемо говорити тільки про автозавантаження класів. Тим не менш, все описане застосовно до інтерфейсів і трейтам.

Як використовувати автозавантажувач Yii <a name="using-yii-autoloader"></a>
--------------------------------------------------------------

При використанні автозавантажувач класів Yii слід дотримуватися два простих правила створення і іменування класів:

* Кожен клас повинен належати простору імен (тобто `foo\bar\MyClass`).
* Кожен клас повинен знаходитися в окремому файлі, шлях до якого визначаться наступним правилом:

```php
// $className — це абсолютне ім'я класу, що починається з "\"
$classFile = Yii::getAlias('@' . str_replace('\\', '/', $className) . '.php');
```

Наприклад, якщо абсолютне ім'я класу `foo\bar\MyClass`, то [псевдонім шляху](concept-aliases.md) даного файлу буде
`@foo/bar/MyClass.php`. Для того, щоб даний псевдонім можна було перетворити в шлях до файлу, необхідно щоб або `@foo` або `@foo/bar` був [кореневим псевдонімом](concept-aliases.md#defining-aliases).

при використанні [шаблону додатку basic](start-basic.md) ви можете зберігати свої класи в просторі імен `app`.
В цьому випадку вони будуть завантажуватися автоматично без створення нового псевдоніма. Це працює тому як `@app`
є [заздалегідь певним псевдонімом](concept-aliases.md#predefined-aliases) і таке ім'я класу як
`app\components\MyClass` відповідно до описаного вище алготімом перетвориться в шлях
`директорияПриложения/components/MyClass.php`.

В [шаблоні додатку advanced](tutorial-advanced-app.md) кожен рівень додатку володіє власним кореневим псевдонімом. Наприклад, для frontend кореневим псевдонімом є `@frontend`, а для backend — `@backend`. Це дозволяє
розмістити класи frontend в простір імен `frontend`, а класи backend в простір імен `backend`. При цьому класи будуть завантажені автоматично.


Карта класів <a name="class-map"></a>
---------------------------------

Автозавантажувач Yii підтримує *карту класів*. Ця можливість дозволяє вказати шлях до файлу для кожного імені класу. 
При завантаженні класу автозавантажувач перевіряє наявність класу в карті. Якщо він там є, відповідний файл буде завантажений 
безпосередньо без будь-яких додаткових перевірок. Це робить автозагрузку дуже швидкою. Всі класи самого фреймворка 
завантажуються саме цим способом.

Ви маєте можливість додати клас в карту `Yii::$classMap` наступним чином:

```php
Yii::$classMap['foo\bar\MyClass'] = 'path/to/MyClass.php';
```

Для вказівки шляхів до файлів класів можна використовувати [псевдоніми](concept-aliases.md). Карту класів необхідно сформувати в процесі [первинного завантаження](runtime-bootstrapping.md) так як вона повинна бути готова до використання класів.


Використання інших автозавантажувачів <a name="using-other-autoloaders"></a>
------------------------------------------------------------------

Так як Yii використовує Composer в якості менеджера залежностей, рекомендується додатково встановити його автозавантажувач. 
Якщо ви використовуєте які-небудь сторонні бібліотеки, в яких є свої Автозавантажувач, ці Автозавантажувач також необхідно 
встановити.

При використанні додаткових автозавантажувач файл `Yii.php` повинен бути підключений *після* їх установки. це дозволить
автозавантажувачу Yii першим пробувати завантажити клас. Приміром, наведений нижче код взятий з
[вхідного скрипта](structure-entry-scripts.md) [шаблону додатку basic](start-basic.md). Перший рядок встановлює автозавантажувач Composer, а друга - автозавантажувач Yii:

```php
require(__DIR__ . '/../vendor/autoload.php');
require(__DIR__ . '/../vendor/yiisoft/yii2/Yii.php');
```

Ви можете використовувати автозавантажувач Composer без автозавантажувач Yii. Однак, швидкість автозавантаження в цьому випадку може зменшиться. Також вам буде необхідно слідувати правилам автозавантажувача Composer.

> Інформація: Якщо ви не хочете використовувати автозавантажувач Yii, створіть свою версію файлу `Yii.php`
  і підключіть його в [вхідному скрипті](structure-entry-scripts.md).


Автозагрузка класів розширень <a name="autoloading-extension-classes"></a>
-------------------------------------------------------------------

Автозавантажувач Yii може автоматично завантажувати класи [розширень](structure-extensions.md) в тому випадку, якщо дотримується єдине правило. Розширення повинно правильно описати розділ 'autoload' у файлі 'composer.json'. Більш докладно про це можна дізнатися з [офіційній документації Composer](https://getcomposer.org/doc/04-schema.md#autoload).

Якщо ви не використовуєте автозавантажувач Yii, то класи розширень можуть бути автоматично завантажені з допомогою автозавантажувач Composer.
