Псевдонимы 
=======

Псевдонимы используются для представления путей к файлам или для представления URL адресов с целью того, чтобы не приходилось полностью прописывать пути к файлам или полные URL адреса.
Псевдоним должен начинаться со знака '@', чтобы не перепутать его с адресом файла или с URL адресом.
Например псевдоним '@yii' указывает на папку, в которую был установлен Yii framework, а псевдоним '@web' представляет собой базовый, основной URL адрес (base URL) текущего приложения.


Создание псевдонимов <a name="defining-aliases"></a>
----------------

Для создания псевдонима пути к файлу или псевдонима  какого либо URL адреса используется метод [[Yii::setAlias()]].
Пример:

```php
// псевдоним пути к файлу
Yii::setAlias('@foo', '/path/to/foo');

// псевдоним URL адреса
Yii::setAlias('@bar', 'http://www.example.com');
```

> Примечание: псевдоним пути к файлу или псевдоним URL адреса могут указывать на НЕСУЩЕСТВУЮЩИЙ файл или интернет ресурс.

Если вы создали псевдоним пути, то из него можно вывести производный путь(не вызывая [[Yii::setAlias()]]) с помощью добавления знака '/' с последующим указанием необходимого пути. Псевдонимы, созданные с помощью [[Yii::setAlias()]] называются *корневыми псевдонимами (root aliases)*, тогда как производные псевдонимы называются *производными псевдонимами (derived aliases)*. 
Например, `@foo` - это корневой псевдоним, тогда как `@foo/bar/file.php` - это производный псевдоним.

Вы можете создать новый псевдоним используя ранее созданный псевдоним (независимо от того корневой он или производный):

```php
Yii::setAlias('@foobar', '@foo/bar');
```

Корневые псевдонимы как правило создаются на этапе [предварительной загрузки (bootstrapping)](runtime-bootstrapping.md) stage.
Например вы можете вызвать [[Yii::setAlias()]] внутри [входного скрипта (entry script)](structure-entry-scripts.md).
Для удобства использования, в [приложении (Application)](structure-applications.md) предусмотрено свойство 'aliases' , в которое возможна запись, т.е. вы можете [изменить настройки](concept-configurations.md) вашего приложения как в нижеследующем примере:

```php
return [
    // ...
    'aliases' => [
        '@foo' => '/path/to/foo',
        '@bar' => 'http://www.example.com',
    ],
];
```


Раскрытие Псевдонимов <a name="resolving-aliases"></a>
-----------------

Метод [[Yii::getAlias()]] раскрывает корневой псевдоним в путь к файлу или в URL, который изначально был скрыт за псевдонимом.
Этот же метод используется для раскрытия производных псевдонимов в полный путь. 
Пример:

```php
echo Yii::getAlias('@foo');               // выведет: /path/to/foo
echo Yii::getAlias('@bar');               // выведет: http://www.example.com
echo Yii::getAlias('@foo/bar/file.php');  // выведет: /path/to/foo/bar/file.php
```

При раскрытии производных псевдонимов происходит раскрытие корневого псевдонима, с которого начинался псевдоним. 

> Примечание: Метод [[Yii::getAlias()]] не проверяет фактическое существование формируемого пути к файлу или URL адреса. 

Корневой псевдоним может включать в себя знаки '/'. Метод [[Yii::getAlias()]] 
корректно определит какая часть ссылки является корневой.
Пример:

```php
Yii::setAlias('@foo', '/path/to/foo');
Yii::setAlias('@foo/bar', '/path2/bar');
Yii::getAlias('@foo/test/file.php');  // выведет: /path/to/foo/test/file.php
Yii::getAlias('@foo/bar/file.php');   // выведет: /path2/bar/file.php
```

Если не указать `@foo/bar` в качестве корневого псевдонима, последнее выражение выведет `/path/to/foo/bar/file.php`.


Использование псевдонимов <a name="using-aliases"></a>
-------------

Псевдонимы распознаются во многих частях Yii без необходимости вызова [[Yii::getAlias()]] для раскрытия псевдонимов. Например, [[yii\caching\FileCache::cachePath]] принимает в качестве аргумента как обычный путь к файлу, так и псевдоним, благодаря тому, что псевдонимы начинаются со знака '@'.

```php
use yii\caching\FileCache;

$cache = new FileCache([
    'cachePath' => '@runtime/cache',
]);
```

Для того чтобы узнать, поддерживает ли необходимый вам метод или свойство класса псевдонимы в качестве аргументов обратитесь к документации API. 


Системные псевдонимы <a name="predefined-aliases"></a>
------------------

Системные псевдонимы Yii включают в себя часто используемые пути к файлам и URL адреса.
Список системных псевдонимов Yii:

- `@yii`: папка, в которой находится файл `BaseYii.php` (директория фреймворка).
- `@app`: [[yii\base\Application::basePath|base path]] текущего приложения.
- `@runtime`: [[yii\base\Application::runtimePath|runtime path]] текущего приложения.
- `@vendor`: [[yii\base\Application::vendorPath|Composer vendor directory].
- `@webroot`: папка Web root текущего Web приложения.
- `@web`: базовый URL (base URL) текущего приложения.

Псевдоним `@yii` создается при включении файла `Yii.php` во [входной скрипт (entry script)](structure-entry-scripts.md),
остальные псевдонимы создаются в конструкторе приложения в момент применения [конфигурации](concept-configurations.md).


Псевдонимы расширений <a name="extension-aliases"></a>
-----------------

Для каждого [расширения](structure-extensions.md), устанавливаемого через Composer автоматически создается псевдоним.
Имя псевдонима расширения соответствует корневому пространству имен, которое указано в файле `composer.json` расширения. Данный псевдоним указывает на корневую папку расширения.
Например, если вы установите расширение `yiisoft/yii2-jui`, то для вас автоматически станет доступен псевдоним `@yii/jui`, создание которого будет происходить на этапе [первоначальной загрузки (bootstrapping)](runtime-bootstrapping.md) следующим образом:

```php
Yii::setAlias('@yii/jui', 'VendorPath/yiisoft/yii2-jui');
```
