<?php

namespace yiiunit\framework\validators;


use yii\validators\RangeValidator;
use yiiunit\data\validators\models\FakedValidationModel;
use yiiunit\TestCase;

class RangeValidatorTest extends TestCase
{
	public function testInitException()
	{
		$this->setExpectedException('yii\base\InvalidConfigException', 'The "range" property must be set.');
		$val = new RangeValidator(array('range' => 'not an array'));
	}

	public function testAssureMessageSetOnInit()
	{
		$val = new RangeValidator(array('range' => array()));
		$this->assertTrue(is_string($val->message));
	}

	public function testValidateValue()
	{
		$val = new RangeValidator(array('range' => range(1, 10, 1)));
		$this->assertTrue($val->validateValue(1));
		$this->assertFalse($val->validateValue(0));
		$this->assertFalse($val->validateValue(11));
		$this->assertFalse($val->validateValue(5.5));
		$this->assertTrue($val->validateValue(10));
		$this->assertTrue($val->validateValue("10"));
		$this->assertTrue($val->validateValue("5"));
	}

	public function testValidateValueStrict()
	{
		$val = new RangeValidator(array('range' => range(1, 10, 1), 'strict' => true));
		$this->assertTrue($val->validateValue(1));
		$this->assertTrue($val->validateValue(5));
		$this->assertTrue($val->validateValue(10));
		$this->assertFalse($val->validateValue("1"));
		$this->assertFalse($val->validateValue("10"));
		$this->assertFalse($val->validateValue("5.5"));
	}

	public function testValidateValueNot()
	{
		$val = new RangeValidator(array('range' => range(1, 10, 1), 'not' => true));
		$this->assertFalse($val->validateValue(1));
		$this->assertTrue($val->validateValue(0));
		$this->assertTrue($val->validateValue(11));
		$this->assertTrue($val->validateValue(5.5));
		$this->assertFalse($val->validateValue(10));
		$this->assertFalse($val->validateValue("10"));
		$this->assertFalse($val->validateValue("5"));
	}

	public function testValidateAttribute()
	{
		$val = new RangeValidator(array('range' => range(1, 10, 1)));
		$m = FakedValidationModel::createWithAttributes(array('attr_r1' => 5, 'attr_r2' => 999));
		$val->validateAttribute($m, 'attr_r1');
		$this->assertFalse($m->hasErrors());
		$val->validateAttribute($m, 'attr_r2');
		$this->assertTrue($m->hasErrors('attr_r2'));
		$err = $m->getErrors('attr_r2');
		$this->assertTrue(stripos($err[0], 'attr_r2') !== false);
	}
}