What is Yii
===========

Yii is a high-performance, component-based PHP framework for rapidly developing large-scale Web applications. Yii enables maximum reusability in Web
programming and can significantly accelerate your Web application development
process. The name Yii (pronounced `Yee` or `[ji:]`) is an acronym for
**Yes It Is!**.


Requirements
------------

To run a Yii-powered Web application, you need a Web server that supports
PHP 5.4.0 or greater.

For developers who want to use Yii, understanding object-oriented
programming (OOP) is very helpful, as Yii is a pure OOP framework.
Yii 2.0 also makes use of the latest features of PHP, including [namespaces](http://www.php.net/manual/en/language.namespaces.php),
so you should be familiar with how those work, too.


What is Yii Best for?
---------------------

Yii is a generic Web programming framework that can be used for developing
virtually any type of Web application. Because it is light weight and
equipped with sophisticated caching mechanisms, Yii is especially suited
to high-traffic applications such as portals, forums, content
management systems (CMS), e-commerce projects, and so on.


How does Yii Compare with Other Frameworks?
-------------------------------------------

- Like most PHP frameworks, Yii uses the MVC (Model-View-Controller) design approach.
- Yii is a full-stack framework providing many solutions and components, such as logging, session management, caching, etc.
- Yii strikes a good balance between simplicity and being feature-rich.
- Syntax and overall development usability are taken seriously by the Yii development team.
- Performance is one of the key goals for the Yii framework.
- The Yii development team is constantly watching what other Web frameworks are doing to consider what best practices and
  features should be incorporated into Yii. The initial Yii release was heavily influenced by Ruby on Rails.
  Still, no framework or feature is being blindly copied into Yii; all decisions are based upon what's best
  for Web developers and in keeping with Yii's philosophy.
