Guia Definitivo para Yii 2.0
============================

Esse tutorial está disponível sob os [termos da documentação do Yii](http://www.yiiframework.com/doc/terms/).

Todos os Direitos Reservados.

2014 (c) Yii Software LLC.


Introdução
----------

* [Sobre o Yii](intro-yii.md)
* [Migrando a partir da versão 1.1](intro-upgrade-from-v1.md)


Primeiros Passos
----------------

* [Instalando o Yii](start-installation.md)
* [Executando Aplicações](start-workflow.md)
* [Como Fazer um "Hello World"](start-hello.md)
* [Trabalhando com Formulários](start-forms.md)
* [Trabalhando com Bancos de Dados](start-databases.md)
* [Gerando Código com Gii](start-gii.md)
* [Seguindo em Frente](start-looking-ahead.md)


Estrutura de uma Aplicação
--------------------------

* [Visão Geral](structure-overview.md)
* [Scripts de Entrada](structure-entry-scripts.md)
* [Aplicações](structure-applications.md)
* [Componentes de Aplicação](structure-application-components.md)
* [Controllers (Controladores)](structure-controllers.md)
* [Models (Modelos)](structure-models.md)
* [Views (Visões)](structure-views.md)
* [Módulos](structure-modules.md)
* [Filtros](structure-filters.md)
* [Widgets](structure-widgets.md)
* [Assets](structure-assets.md)
* [Extensões](structure-extensions.md)


Tratamento de Requisições
-------------------------

* [Visão Geral](runtime-overview.md)
* [Bootstrapping](runtime-bootstrapping.md)
* [Roteamento e Criação de URL](runtime-routing.md)
* [Requisições](runtime-requests.md)
* [Respostas](runtime-responses.md)
* [Sessões e Cookies](runtime-sessions-cookies.md)
* [Tratamento de Erros](runtime-handling-errors.md)
* [Gerenciamento de Logs](runtime-logging.md)


Conceitos Chave
---------------

* [Componentes](concept-components.md)
* [Propriedades](concept-properties.md)
* [Eventos](concept-events.md)
* [Behaviors (Comportamentos)](concept-behaviors.md)
* [Configurações](concept-configurations.md)
* [Aliases](concept-aliases.md)
* [Autoloading de Classes](concept-autoloading.md)
* [Service Locator](concept-service-locator.md)
* [Container de Injeção de Dependência](concept-di-container.md)


Trabalhando com Banco de Dados
------------------------------

* [Data Access Objects (DAO, Objeto de Acesso a Dados)](db-dao.md)? Estabelecendo uma conexão com o Banco de Dados, consultas básicas, transações e manipulação do esquema
* [Query Builder (Construtor de Consulta)](db-query-builder.md)? Consultando o banco de dados usando uma camada de abstração simples
* [Active Record](db-active-record.md): Sobre o Active Record ORM, recuperando e manipulando registros e definindo relacionamentos
* [Migrations (Migrações)](db-migrations.md): Aplica controle de versão para seus banco de dados em um ambiente de desenvolvimento em equipe
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elasticsearch.md)


Coletando Dados de Usuários
---------------------------

* [Criando Formulários](input-forms.md)
* [Validação de Dados](input-validation.md)
* [Upload de Arquivos](input-file-upload.md)
* **TBD** [Coletando Dados de Múltiplos Modelos](input-multiple-models.md)


Exibindo Dados
---------------

* [Formatando Dados](output-formatter.md)
* **TBD** [Paginação](output-pagination.md)
* **TBD** [Ordenação](output-sorting.md)
* [Data Providers (Provedores de Dados)](output-data-providers.md)
* [Widgets de Dados](output-data-widgets.md)
* [Trabalhando com Client Scripts](output-client-scripts.md)
* [Temas](output-theming.md)


Segurança
--------

* [Autenticação](security-authentication.md)
* [Autorização](security-authorization.md)
* [Trabalhando com Senhas](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* [Melhores Práticas](security-best-practices.md)


Cache
-------

* [Visão Geral](caching-overview.md)
* [Cache de Dados](caching-data.md)
* [Cache de Fragmento](caching-fragment.md)
* [Cache de Página](caching-page.md)
* [Cache HTTP](caching-http.md)


Web Services RESTful 
------------------------

* [Introdução](rest-quick-start.md)
* [Recursos](rest-resources.md)
* [Controllers (Controladores)](rest-controllers.md)
* [Roteamento](rest-routing.md)
* [Formatando Respostas](rest-response-formatting.md)
* [Autenticação](rest-authentication.md)
* [Rate Limiting](rest-rate-limiting.md)
* [Versionamento](rest-versioning.md)
* [Tratamento de Erros](rest-error-handling.md)


Ferramentas de Desenvolvimento
------------------------------

* [Barra de Ferramentas de Depuração e Depurador](tool-debugger.md)
* [Gerando Código usando o Gii](tool-gii.md)
* **TBD** [Gerando Documentação da API](tool-api-doc.md)


Testes
------

* [Visão Geral](test-overview.md)
* [Configuração do ambiente de testes](test-environment-setup.md)
* [Testes Unitários](test-unit.md)
* [Testes Funcionais](test-functional.md)
* [Testes de Aceitação](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Tópicos Especiais
-----------------

* [Modelo de Aplicação Avançada](tutorial-advanced-app.md)
* [Construindo uma Aplicação a Partir do Zero](tutorial-start-from-scratch.md)
* [Comandos de Console](tutorial-console.md)
* [Ferramentas de Validação Embutidas](tutorial-core-validators.md)
* [Internacionalização](tutorial-i18n.md)
* [Enviando E-mails](tutorial-mailing.md)
* [Ajustes no Desempenho](tutorial-performance-tuning.md)
* [Ambiente de Hospedagem Compartilhada](tutorial-shared-hosting.md)
* [Motor de Template](tutorial-template-engines.md)
* [Utilização com Códigos de Terceiros](tutorial-yii-integration.md)


Widgets
-------

* GridView: **TBD** link para a página de demonstração
* ListView: **TBD** link para a página de demonstração
* DetailView: **TBD** link para a página de demonstração
* ActiveForm: **TBD** link para a página de demonstração
* Pjax: **TBD** link para a página de demonstração
* Menu: **TBD** link para a página de demonstração
* LinkPager: **TBD** link para a página de demonstração
* LinkSorter: **TBD** link para a página de demonstração
* [Widgets do Bootstrap](widget-bootstrap.md)
* [Widgets do Jquery UI](widget-jui.md)


Helpers
-------

* [Visão Geral](helper-overview.md)
* [ArrayHelper](helper-array.md)
* [Html](helper-html.md)
* [Url](helper-url.md)
* **TBD** [Segurança](helper-security.md)

