Generating Code with Gii
========================

In this section, we will describe how to use [Gii](tool-gii.md) to automatically generate the code
that implements some common features. To achieve this goal, all you need is just to enter the needed
information according to the instructions showing on the Gii Web pages.

Through this tutorial, you will learn

* How to enable Gii in your application;
* How to use Gii to generate an Active Record class;
* How to use Gii to generate the code implementing the CRUD operations for a DB table.
* How to customize the code generated by Gii.


Starting Gii <a name="starting-gii"></a>
------------

[Gii](tool-gii.md) is provided by Yii in terms of a [module](structure-modules.md). You can enable Gii
by configuring it in the [[yii\base\Application::modules|modules]] property of the application. In particular,
you may find the following code is already given in the `config/web.php` file - the application configuration,

```php
$config = [ ... ];

if (YII_ENV_DEV) {
    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = 'yii\gii\Module';
}
```

The above configuration states that when in [development environment](concept-configurations.md#environment-constants),
the application should include a module named `gii` which is of class [[yii\gii\Module]].

If you check the [entry script](structure-entry-scripts.md) `web/index.php` of your application, you will
find the following line which essentially makes `YII_ENV_DEV` to be true.

```php
defined('YII_ENV') or define('YII_ENV', 'dev');
```

Therefore, your application has already enabled Gii, and you can access it via the following URL:

```
http://hostname/index.php?r=gii
```

![Gii](images/start-gii.png)


Generating an Active Record Class <a name="generating-ar"></a>
---------------------------------

To use Gii to generate an Active Record class, select the "Model Generator" and fill out the form as follows,

* Table Name: `country`
* Model Class: `Country`

![Model Generator](images/start-gii-model.png)

Click on the "Preview" button. You will see `models/Country.php` is listed in the result.
You may click on it to preview its content.

Because in the last section, you have already created the same file `models/Country.php`, if you click
the `diff` button next to the file name, you will see the difference between the code to be generated
and the code that you have already written.

![Model Generator Preview](images/start-gii-model-preview.png)

Check the checkbox next to "overwrite" and then click on the "Generate" button. You will see
a confirmation page indicating the code has been successfully generated and your existing `models/Country.php`
is overwritten with the newly generated code.


Generating CRUD Code <a name="generating-crud"></a>
--------------------

To create CRUD code, select the "CRUD Generator". Fill out the form as follows:

* Model Class: `app\models\Country`
* Search Model Class: `app\models\CountrySearch`
* Controller Class: `app\controllers\CountryController`

![CRUD Generator](images/start-gii-crud.png)

Click on the "Preview" button. You will see a list of files to be generated, as shown below.

Make sure you have checked the overwrite checkboxes for both `controllers/CountryController.php` and
`views/country/index.php` files. This is needed because you have already created these files
in the previous section and you want to have them overwritten to have full CRUD support.


How It Works <a name="how-it-works"></a>
------------

To see how it works, use your browser to access the following URL:

```
http://hostname/index.php?r=country/index
```

You will see a data grid showing the countries in the database table. You may sort the grid
or filter it by entering filter conditions in the column headers.

For each country displayed in the grid, you may choose to view its detail, update it or delete it.
You may also click on the "Create Country" button on top of the grid to create a new country.

![Data Grid of Countries](images/start-gii-country-grid.png)

![Updating a Country](images/start-gii-country-update.png)

The following is the list of the generated files in case you want to dig out how these features are implemented,
or if you want to customize them.

* Controller: `controllers/CountryController.php`
* Models: `models/Country.php` and `models/CountrySearch.php`
* Views: `views/country/*.php`

> Info: Gii is designed to be a highly customizable and extensible code generation tool. Using it wisely
  can greatly accelerate your application development speed. For more details, please refer to
  the [Gii](tool-gii.md) section.


Summary <a name="summary"></a>
-------

In this section, you have learned how to use Gii to generate the code that implements a complete
set of CRUD features regarding a database table.
