Yii 2.0 权威指南
===============================

本指南依据 [Terms of Yii Documentation](http://www.yiiframework.com/doc/terms/) 发布。

保留所有权利。

2014 (c) Yii Software LLC.


简介
------------

* [关于 Yii](intro-yii.md)
* [从 1.1 版本升级](intro-upgrade-from-v1.md)


入门
---------------

* [安装 Yii](start-installation.md)
* [运行应用程序](start-workflow.md)
* [说一声你好](start-hello.md)
* [使用表单](start-forms.md)
* [使用数据库](start-databases.md)
* [用 Gii 生成代码](start-gii.md)
* [一路向前](start-looking-head.md)


程序结构
---------------------

* [概览](structure-overview.md)
* [入口脚本](structure-entry-scripts.md)
* [应用程序](structure-applications.md)
* [应用程序组件](structure-application-components.md)
* [控制器](structure-controllers.md)
* [模型](structure-models.md)
* [视图](structure-views.md)
* **TBD** [过滤器](structure-filters.md)
* **TBD** [挂件](structure-widgets.md)
* **TBD** [模块](structure-modules.md)
* [资源](structure-assets.md)
* **TBD** [扩展](structure-extensions.md)


处理请求
-----------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Routing](runtime-routing.md)
* **TBD** [Requests](runtime-requests.md)
* **TBD** [Responses](runtime-responses.md)
* **TBD** [Sessions and Cookies](runtime-sessions-cookies.md)
* [URL 解析及生成](runtime-url-handling.md)
* [处理错误](runtime-handling-errors.md)
* [日志](runtime-logging.md)


关键概念
------------

* [组件](concept-components.md)
* [属性](concept-properties.md)
* [事件](concept-events.md)
* [行为](concept-behaviors.md)
* [配置](concept-configurations.md)
* [别名](concept-aliases.md)
* [类的自动加载](concept-autoloading.md)
* [服务定位器](concept-service-locator.md)
* [依赖注入容器](concept-di-container.md)


使用数据库
----------------------

* [Data Access Objects](db-dao.md) - Connecting to a database, basic queries, transactions and schema manipulation
* [Query Builder](db-query-builder.md) - Querying the database using a simple abstraction layer
* [Active Record](db-active-record.md) - The active record ORM, retrieving and manipulating records and defining relations
* [Migrations](db-migrations.md) - Version control your databases in a team development environment
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


获取来自用户的数据
-----------------------

* [创建表单](input-forms.md)
* [验证输入](input-validation.md)
* **TBD** [Uploading Files](input-file-upload.md)
* **TBD** [Getting Data for Multiple Models](input-multiple-models.md)


显示数据
---------------

* **TBD** [Data Formatting](output-formatting.md)
* **TBD** [Pagination](output-pagination.md)
* **TBD** [Sorting](output-sorting.md)
* [Data Providers](output-data-providers.md)
* [Data Widgets](output-data-widgets.md)
* [主题](output-theming.md)


安全
--------

* [验证](security-authentication.md)
* [授权](security-authorization.md)
* [使用密码](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Best Practices](security-best-practices.md)


缓存
-------

* [概览](caching-overview.md)
* [数据缓存](caching-data.md)
* [片段缓存](caching-fragment.md)
* [页面缓存](caching-page.md)
* [HTTP 缓存](caching-http.md)


RESTful Web 服务
--------------------

* [快速入门](rest-quick-start.md)
* [Resources](rest-resources.md)
* [Controllers](rest-controllers.md)
* [Routing](rest-routing.md)
* [Response Formatting](rest-response-formatting.md)
* [Authentication](rest-authentication.md)
* [Rate Limiting](rest-rate-limiting.md)
* [Versioning](rest-versioning.md)
* [Error Handling](rest-error-handling.md)


开发工具
-----------------

* [Debug Toolbar and Debugger](tool-debugger.md)
* [Generating Code using Gii](tool-gii.md)
* **TBD** [Generating API Documentation](tool-api-doc.md)


测试
-------

* [Overview](test-overview.md)
* **TBD** [Unit Tests](test-unit.md)
* **TBD** [Functional Tests](test-functional.md)
* **TBD** [Acceptance Tests](test-acceptance.md)
* [Fixtures](test-fixtures.md)


扩展 Yii
-------------

* [创建扩展](extend-creating-extensions.md)
* [定制核心代码](extend-customizing-core.md)
* [使用第三方库](extend-using-libs.md)
* **TBD** [Using Yii in 3rd-Party Systems](extend-embedding-in-others.md)
* **TBD** [Using Yii 1.1 and 2.0 Together](extend-using-v1-v2.md)
* [使用 Composer](extend-using-composer.md)


专题
--------------

* [高级应用程序模板](tutorial-advanced-app.md)
* [从头开始构建应用程序](tutorial-start-from-scratch.md)
* [控制台命令](tutorial-console.md)
* [核心验证器](tutorial-core-validators.md)
* [国际化](tutorial-i18n.md)
* [发送邮件](tutorial-mailing.md)
* [性能调节](tutorial-performance-tuning.md)
* **TBD** [共享的主机环境](tutorial-shared-hosting.md)
* [模板引擎](tutorial-template-engines.md)


挂件（Widgets)
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)


助手(Helpers)
-------

* [概览](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

