コンソールアプリケーション
==========================

> Note|注意: この節はまだ執筆中です。

Yii はフル機能のコンソールアプリケーションをサポートしています。
コンソールアプリケーションの構造は Yii のウェブアプリケーションのそれと非常に良く似ています。
コンソールアプリケーションは一つまたは複数の [[yii\console\Controller]] から構成されます。
コントローラはコンソール環境では通常「コマンド」と呼ばれます。
また、各コントローラは、ウェブのコントローラと全く同じように、一つまたは複数のアクションを持つことが出来ます。


使用方法 <a name="usage"></a>
--------

コンソールのコントローラアクションは次の構文を使って実行します。

```
yii <route> [--option1=value1 --option2=value2 ... argument1 argument2 ...]
```

例えば、[[yii\console\controllers\MigrateController::$migrationTable|MigrateController::$migrationTable]] を指定して [[yii\console\controllers\MigrateController::actionCreate()|MigrateController::actionCreate()]] をコマンドラインから呼び出すためには、次のようにします。

```
yii migrate/create --migrationTable=my_migration
```

上記において `yii` はコンソールアプリケーションのエントリスクリプトです。
これについては下で説明します。

> **注意**: コンソールで `*` を使う場合は、`"*"` として引用符号で囲むことを忘れないでください。
> これは、`*` をカレントディレクトリの全てのファイル名に置き換えられるシェルのグロブとして実行してしまうことを避けるためです。


エントリスクリプト <a name="entry-script"></a>
------------------

コンソールアプリケーションのエントリスクリプトは、ウェブアプリケーションで使用されるブートストラップファイル `index.php` に相当するものです。
コンソールのエントリスクリプトは通常は `yii` と呼ばれるもので、アプリケーションのルートディレクトリに配置されています。
それは次のようなコードを含んでいます。

```php
#!/usr/bin/env php
<?php
/**
 * Yii console bootstrap file.
 */

defined('YII_DEBUG') or define('YII_DEBUG', true);

// fcgi では、デフォルトでは、STDIN と STDOUT が定義されていない
defined('STDIN') or define('STDIN', fopen('php://stdin', 'r'));
defined('STDOUT') or define('STDOUT', fopen('php://stdout', 'w'));

require(__DIR__ . '/vendor/autoload.php');
require(__DIR__ . '/vendor/yiisoft/yii2/Yii.php');

$config = require(__DIR__ . '/config/console.php');

$application = new yii\console\Application($config);
$exitCode = $application->run();
exit($exitCode);
```

このスクリプトはアプリケーションの一部として生成されるものです。
あなたの必要を満たすように、自由に編集して構いません。
エラー発生時にスタックトレースを見たくない、または、全体のパフォーマンスを上げたい、という場合は、`YII_DEBUG` 定数を `false` に設定することが出来ます。
ベーシックアプリケーションテンプレートでも、アドバンストアプリケーションテンプレートでも、コンソールアプリケーションのエントリスクリプトは、開発者に優しい環境を提供するために、デフォルトでデバッグを有効にしています。


構成情報 <a name="configuration"></a>
--------

上記のコードで見るように、コンソールアプリケーションは、`console.php` という名前のそれ自身の構成情報ファイルを使用します。
このファイルの中で、さまざまな [アプリケーションコンポーネント](structure-application-components.md)、取り分け、コンソールアプリケーションのためのプロパティを構成しなければなりません。

ウェブアプリケーションとコンソールアプリケーションが構成情報のパラメータと値を数多く共有する場合は、共通の部分を独立したファイルに移動して、そのファイルを両方のアプリケーション (ウェブとコンソール) の構成情報にインクルードすることを検討しても良いでしょう。
その例を「アドバンスト」アプリケーションテンプレートの中で見ることが出来ます。

> Tip|ヒント: 場合によっては、エントリスクリプトで指定されているのとは異なるアプリケーション構成情報を使ってコンソールコマンドを実行したいことがあります。
> 例えば、`yii migrate` コマンドを使ってテストのデータベースをアップグレードするとき、データベースが個々のテストスイートの中で構成されているような場合です。
> 構成情報を動的に変更するためには、コマンドを実行するときに `appconfig` オプションを使ってカスタムの構成情報ファイルを指定するだけで大丈夫です。
> 
> ```
> yii <route> --appconfig=path/to/config.php ...
> ```


あなた自身のコンソールコマンドを作成する <a name="create-command"></a>
----------------------------------------

### コンソールのコントローラとアクション

コンソールコマンドは、[[yii\console\Controller]] を拡張するコントローラクラスとして定義することが出来ます。
コントローラクラスの中で、コントローラのサブコマンドに対応する一つまたは複数のアクションを定義します。
各アクションの中で、特定のサブコマンドのために、適切なタスクを実装するコードを書きます。

コマンドを実行するときは、コントローラのアクションに対するルートを指定する必要があります。
例えば、ルート `migrate/create` は、[[yii\console\controllers\MigrateController::actionCreate()|MigrateController::actionCreate()]] アクションメソッドに対応するサブコマンドを呼び出します。
実行時に提供されたルートにアクション ID が含まれない場合は、(ウェブのコントローラの場合と同じように) デフォルトのアクションが実行されます。

### オプション

[[yii\console\Controller::options()]] メソッドをオーバーライドすることによって、コンソールコマンド (controller/actionID) で利用できるオプションを指定することが出来ます。
このメソッドはコントローラクラスのパブリックなプロパティのリストを返さなければなりません。
コマンドを実行するときは、`--OptionName=OptionValue` という構文を使ってオプションの値を指定することが出来ます。これはコントローラクラスの `OptionName` プロパティに `OptionValue` を割り当てるものです。

オプションのデフォルト値が配列型である場合、実行時にこのオプションをセットすると、オプションの値は、入力文字列をカンマで分離することによって、配列に変換されます。

### 引数

オプションに加えてに、コマンドは引数を取ることも出来ます。
引数は、リクエストされたサブコマンドに対応するアクションメソッドへのパラメータとして渡されます。
最初の引数は最初のパラメータに対応し、二番目の引数は二番目のパラメータに対応し、以下同様です。
コマンドが呼び出されたときに十分な数の引数が提供されなかったときは、対応するパラメータは、定義されていれば、宣言されているデフォルト値をとります。
デフォルト値が設定されておらず、実行時に値が提供されなかった場合は、コマンドはエラーで終了します。

`array` タイプヒントを使って、引数が配列として扱われるべきことを示すことが出来ます。
配列は入力文字列をカンマで分割することによって生成されます。

次に引数を宣言する方法を示す例を挙げます。

```php
class ExampleController extends \yii\console\Controller
{
    // コマンド "yii example/create test" は "actionCreate('test')" を呼び出す
    public function actionCreate($name) { ... }

    // コマンド "yii example/index city" は "actionIndex('city', 'name')" を呼び出す
    // コマンド "yii example/index city id" は call "actionIndex('city', 'id')" を呼び出す
    public function actionIndex($category, $order = 'name') { ... }

    // コマンド "yii example/add test" は "actionAdd(['test'])" を呼び出す
    // コマンド "yii example/add test1,test2" は "actionAdd(['test1', 'test2'])" を呼び出す
    public function actionAdd(array $name) { ... }
}
```


### 終了コード

終了コードを使うことはコンソールアプリケーション開発のベストプラクティスです。
コマンドは何も問題が無かったことを示すために `0` を返すのが慣例です。
コマンドが 1 以上の値を返したときは、何かエラーを示唆するものとみなされます。
返される数値がエラーコードであり、それによってエラーに関する詳細を見出すことが出来る場合もあります。
例えば、`1` は一般的な未知のエラーを示すものとし、`2` 以上の全てのコードは特定のエラー、例えば、入力エラー、ファイルが見つからない、等々を示すものとすることが出来ます。

コンソールコマンドに終了コードを返させるためには、単にコントローラのアクションメソッドで整数を返すようにします。

```php
public function actionIndex()
{
    if (/* 何らかの問題が発生 */) {
        echo "問題が生じました!\n";
        return 1;
    }
    // 何かをする
    return 0;
}
```

いくつか使用できる事前定義された定数があります。

- `Controller::EXIT_CODE_NORMAL` - 値は `0`
- `Controller::EXIT_CODE_ERROR` - 値は `1`

もっと多くのエラーコードの種類がある場合は、コントローラで意味のある定数を定義するのが良いプラクティスです。

### 書式設定と色

Yii のコンソールコマンドは出力の書式設定をサポートしています。
これは、コマンドを走らせている端末がサポートしていない場合は、自動的に書式設定の無い出力にグレードダウンされます。

書式設定された文字列を出力することは簡単です。
ボールドのテキストを出力するには、次のようにします。

```php
$this->stdout("Hello?\n", Console::BOLD);
```

複数のスタイルを動的に結合して文字列を構成する必要がある場合は、`ansiFormat` を使うほうが良いでしょう。

```php
$name = $this->ansiFormat('Alex', Console::FG_YELLOW);
echo "Hello, my name is $name.";
```
