共有ホスティング環境
====================

共有ホスティング環境では、たいてい、構成やディレクトリ構造について、大きな制約があります。
それでも、ほとんどの場合、Yii 2.0 を共有ホスティング環境で走らせることは可能です。

ベーシックアプリケーションを配備する
------------------------------------

通例、一つのウェブルートしかありませんので、ベーシックアプリケーションテンプレートを使用することを推奨します。
[Yii をインストールする](start-installation.md) の節を参照して、アプリケーションテンプレートをローカル環境にインストールしてください。

### ウェブサーバのための追加設定 <a name="add-extras-for-webserver"></a>

使用されているウェブサーバが Apache である場合は、次の内容を持つ `.htaccess` ファイルを `web` (`index.php` があるディレクトリ) に追加する必要があります。

```
Options +FollowSymLinks
IndexIgnore */*

RewriteEngine on

# ディレクトリかファイルが存在すれば、それを直接使う
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d

# それ以外は、index.php にフォワードする
RewriteRule . index.php
```

nginx の場合は、追加の構成ファイルは必要がない筈です。

### ウェブルートの名前を変える <a name="renaming-webroot"></a>

FTP またはその他の手段であなたの共有ホストに接続したとき、下記のようなディレクトリが見えれば、あなたはきっとラッキーです。
 
```
config
logs
www
```

上記で `www` はウェブサーバのディレクトリルート (すなわち、ウェブルート) です。
別の名前かもしれません。よくある名前は、`www`、`htdocs`、`public_html` です。
ベーシックアプリケーションテンプレートではウェブルートの名前は `web` になっていますので、アップロードする前に、これをホストのウェブルートの名前に変更する必要があります。

### FTP ルートディレクトリは書き込み可能とする

ルートレベルのディレクトリ、すなわち、`config`、`logs`、`www` があるディレクトリに対して書き込みが出来るのであれば、`assets`、`commands` などをそのままアップロードします。

### 必要条件をチェックする

Yii を走らせるためには、ホストは Yii の必要条件を満たさなければなりません。
最低限の必要条件は PHP 5.4 です。
残りの条件をチェックするために、`requirements.php` をルートディレクトリからウェブルートディレクトリにコピーして、`http://example.com/requirements.php` という URL を使ってブラウザ経由で走らせます。
後でファイルを削除するのを忘れないでください。


アドバンストアプリケーションを配備する
--------------------------------------

アドバンストアプリケーションを共有ホストに配備するのは、ベーシックアプリケーションを配備するのに比べると、少しトリッキーになります。
なぜなら、アドバンストアプリケーションは、共有ホストが通常は持っていない二つのウェブルートを持つからです。
このため、構造を少し修正します。

### エントリスクリプトを単一のウェブルートに移動する

まずは、単一のウェブルートディレクトリが必要です。
上記の [ウェブルートの名前を変える](#renaming-webroot) で説明したように、あなたのホストのウェブルートに合うように名前を付けてください。
次に、以下のような構造を作成します。

```
www
    admin
backend
common
console
environments
frontend
...
```

`www` がフロントエンドディレクトリになりますので、`frontend/web` の内容をそこに移動します。
同じように、`backend/web` の内容を `www/admin` に移動します。
どちらの場合も、`index.php` および `index-test.php` の中のパスを修正する必要があります。

### セッションとクッキーを分離する

元来は、バックエンドとフロントエンドは異なるドメインで走ることを意図されています。
両方を同じドメインに移動すると、二つが同じクッキーを共有して干渉することになります。
これを修正するために、バックエンドのアプリケーション構成 `backend/config/main.php` を以下のように修正します。

```php
'components' => [
    'request' => [
        'csrfParam' => '_backendCSRF',
        'csrfCookie' => [
            'httpOnly' => true,
            'path' => '/admin',
        ],
    ],
    'user' => [
        'identityCookie' => [
            'name' => '_backendIdentity',
            'path' => '/admin',
            'httpOnly' => true,
        ],
    ],
    'session' => [
        'name' => 'BACKENDSESSID',
        'cookieParams' => [
            'path' => '/admin',
        ],
    ],
],
```
