Логгирование
============

> Раздел находится в разработке

В Yii встроен гибкий и расширяемый логгер, который способен обрабатывать сообщения в соответствии с их уровнем важности и типом.
С его помощью также можно фильтровать сообщения по разными критериям и пересылать их в файлы, email, в дебаггер и т.п.

Основы логгирования
-------------------

В самом простом виде логгирование - это просто вызов метода, как в примере ниже:

```php
\Yii::info('Привет, я - тестовое сообщение лога');
```

Вы можете логгировать как данные строкового типа, так и более сложные структуры данных, такие как массивы и объекты. 
Если логгируемые данные - не строка, обработчики логов по умолчанию сериализуют значение, используя [[yii\helpers\Vardumper::export()]].

### Категории сообщений

Вы можете указать категорию сообщения, чтобы разделить сообщения разного типа в дальнейшем, и по разному их обработать. 
Категория сообщения передается вторым аргументом методов логгирования. По умолчанию присваивается категория `application`.

### Уровни важности

Доступно несколько уровней важности и соответствующим им методов логгирования:

- [[Yii::trace]] в основном используется в разработке, чтобы логгировать прогресс выполнения кода. Заметьте, что он работает только в 
режиме разработки, когда константа `YII_DEBUG` имеет значение `true`.
- [[Yii::error]] используется в случае невосстановимой ошибки.
- [[Yii::warning]] используется, когда произошла ошибка, но исполнение может быть продолжено.
- [[Yii::info]] используется, чтобы фиксировать информацию о важных событиях, таких как логин администратора.

Цели сообщений
------------------

Когда вызывается один из логгирующих методов, сообщение передается компоненту [[yii\log\Logger]], доступному через 
`Yii::getLogger()`. Логгер хранит сообщения в памяти, и когда сообщений достаточно для отправки, или когда 
заканчивается текущий запрос, отправляет сообщения по целям назначения, таким как файл или email.


Вы можете конфигурировать цели сообщений таким образом:

```php
[
    'bootstrap' => ['log'], // убеждаемся, что логгер загружается до запуска приложения
    'components' => [
        'log' => [
            'targets' => [
                'file' => [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['trace', 'info'],
                    'categories' => ['yii\*'],
                ],
                'email' => [
                    'class' => 'yii\log\EmailTarget',
                    'levels' => ['error', 'warning'],
                    'message' => [
                        'to' => ['admin@example.com', 'developer@example.com'],
                        'subject' => 'Новое сообщение логгера example.com',
                    ],
                ],
            ],
        ],
    ],
]
```

В конфигурации выше мы назначает две цели: [[yii\log\FileTarget|file]] и [[yii\log\EmailTarget|email]]. В обоих случаях 
мы фильтруем сообщения по важности, а в случае с записью в файл еще и по категории. `yii\*` значит все категории, начинающиеся с `yii\`.

Каждая цель может иметь имя, и к ней можно обращаться через [[yii\log\Logger::targets|targets]] следующим образом:

```php
Yii::$app->log->targets['file']->enabled = false;
```

Когда приложение заканчивает работу, или когда достигнут предел количества сообщений [[yii\log\Logger::flushInterval|flushInterval]], логгер 
вызовет метод [[yii\log\Logger::flush()|flush()]] для отправки сообщений по маршрутам.

> Обратите внимание, что в примере выше мы добавили компонент `log` в список [автозагрузки](runtime-bootstrapping.md) компонентов, чтобы 
он инициализировался в самом начале жизненного цикла приложения, чтобы, в свою очередь, убедиться, что логгирование будет происходить с самого начала 
приложения.


Профилирование
--------------

Профилирование - особый тип сообщений, который может быть использован для замера времени, необходимого определенным 
блокам кода для отработки, чтобы выяснить, где можно улучшить производительность.

Чтобы пользоваться профилированием нужно понять, какие блоки кода нужно профилировать. Затем нужно отметить начало и конец каждого блока, вызывая 
нижеследующие методы:

```php
\Yii::beginProfile('myBenchmark');
...блок кода для профилирования...
\Yii::endProfile('myBenchmark');
```

где `myBenchmark` - уникальный идентификатор блока кода.

Заметьте, что блоки кода должны быть правильно вложены друг в друга. Посмотрите пример ниже:

```php
\Yii::beginProfile('block1');
    // код блока 1
    \Yii::beginProfile('block2');
        // код блока два, который входит в блок один
    \Yii::endProfile('block2');
\Yii::endProfile('block1');
```

Результаты профилирования [можно отображать в дебаггере](module-debug.md).
