Компоненти додатка
==================

Додатки є [сервіс локаторами](concept-service-locators.md). Вони зберігають багато так званих
*компонентів додатку*, які надають різноманітні інструменти для обробки запитів. Наприклад,
компонент `urlManager` відповідає за маршрутизацію веб запитів до потрібного контролера; 
компонент `db` надає інструменти для работи з базою даних; і т. д.

Кожний компонент додатка має свій унікальний ID, який дозволяє ідентифікувати його серед інших різноманітних компонентів
в одному і тому ж додатку. Ви можете отримати доступ до компонента наступним чином:

```php
\Yii::$app->componentID
```

Наприклад, ви можете використовувати `\Yii::$app->db` для отримання [[yii\db\Connection|з’єднання з БД]],
і `\Yii::$app->cache` для отримання доступу до основного компонента [[yii\caching\Cache|кеша]], зареєстрованого в додатку.

Компонент додатка створюється при першому звертанні через попередній вираз. 
Будь-які подальші звертання будуть повертати той же примірник компонента.

Компонентами додатку можуть бути будь-які об’єкти. Ви можете зареєструвати їх за допомогою властивості 
[[yii\base\Application::components]] в [конфігурації](structure-applications.md#application-configurations) додатка.
Наприклад,

```php
[
    'components' => [
        // реєстрація "cache" компонента за допомогою назви класу
        'cache' => 'yii\caching\ApcCache',

        // реєстрація "db" компонента за допомогою масива конфігурації
        'db' => [
            'class' => 'yii\db\Connection',
            'dsn' => 'mysql:host=localhost;dbname=demo',
            'username' => 'root',
            'password' => '',
        ],

        // реєстрація "search" компонента за допомогою анонімної функції
        'search' => function () {
            return new app\components\SolrService;
        },
    ],
]
```

> Інформація: Хоча ви можете зареєструвати стільки компонентів в додатку скільки вам потрібно,
  все ж таки варто робити це осмислено. Компоненти додатку схожі на глобальні змінні. 
  Використання дуже великої кількості компонетів додатку може потенційно зробити ваш код складним для розробки і тестування.
  У більшості випадків ви можете просто створити локальний компонент і використовувати його при необхідності.


## Попереднє завантаження компонентів <a name="bootstrapping-components"></a>

Як згадувалося вище, компонент додатка буде створено при першому звертанні.
Якщо до нього не буде зроблено звертань під час запиту - його взагалі не буде створено.
Однак іноді, ви можете створити екземпляр компонента додатка для кожного запиту, навіть якщо до нього не зверталися явно.
Щоб зробити це, ви можете додати ідентифікатор до властивості [[yii\base\Application::bootstrap|bootstrap]] додатка.

Наприклад, наступна конфігурація додатка завжди гарантує створення компонента `log`:

```php
[
    'bootstrap' => [
        'log',
    ],
    'components' => [
        'log' => [
            // конфігурація для компонента "log"
        ],
    ],
]
```


## Вбудовані компоненти додатку <a name="core-application-components"></a>

В Yii є декілька *вбудованих* компонентів додатку із фіксованими ID та конфігураціями за замовчуванням. 
Наприклад, компонент [[yii\web\Application::request|request]] використовується для збору інформації про запит 
користувача і розбору його у певний [маршрут](runtime-routing.md); компонент [[yii\base\Application::db|db]] 
являє собою з’єднання з базою даних, через яке ви можете виконувати запити. 
Саме з допомогою цих вбудованих компонентів Yii додатки можуть обрабляти запит користувача.

Нижче наведено перелік вбудованих компонентів додатку. Ви можете конфігурувати їх так само, як і інші компоненти додатку.
Коли ви конфігуруєте вбудований компонент додатку і не вказуєте клас цього компонента, то буде використовуватись 
значення за замовчуванням.

* [[yii\web\AssetManager|assetManager]]: використовується для керування і відображенням ресурсів додатку.
  Більш детальна інформація наведена у розділі [Ресурси](output-assets.md).
* [[yii\db\Connection|db]]: являє собою з’єднання з базою даних, через яке ви можете виконувати запити.
  Зверніть увагу, що, коли конфігуруєте даний компонент, ви маєте вказати клас компонента, разом із рештою 
  необхідних параметрів, наприклад [[yii\db\Connection::dsn]].
  Більш детальна інформація наведена у розділі [Об’єкти доступу до даних (DAO)](db-dao.md).
* [[yii\base\Application::errorHandler|errorHandler]]: здійснює обработку PHP помилок і виключень.
  Більш детальна інформація наведена у розділі [Обробка помилок](runtime-handling-errors.md).
* [[yii\i18n\Formatter|formatter]]: форматує дані для відображення їх кінцевому користувачу. Наприклад, число може
  бути відображене із різноманітними роздільниками, дата може бути зображена у розширеному форматі.
  Більш детальна інформація наведена у розділі [Форматування даних](output-formatter.md).
* [[yii\i18n\I18N|i18n]]: використовується для перекладу повідомлень і форматування.
  Більш детальна інформація наведена у розділі [Інтернаціоналізація](tutorial-i18n.md).
* [[yii\log\Dispatcher|log]]: обробка і маршрутизація логів.
  Більш детальна інформація наведена у розділі [Логування](runtime-logging.md).
* [[yii\swiftmailer\Mailer|mail]]: надає можливості для побудови і відправки поштових повідомлень.
  Більш детальна інформація наведена у розділі [Відправлення пошти](tutorial-mailing.md).
* [[yii\base\Application::response|response]]: являє собою об’єкт відповіді сервера кінцевим користувачам.
  Більш детальна інформація наведена у розділі [Відповіді](runtime-responses.md).
* [[yii\base\Application::request|request]]: являє собою об’єкт запиту, який сервер отримує від кінцевих користувачів.
  Більш детальна інформація наведена у розділі [Запити](runtime-requests.md).
* [[yii\web\Session|session]]: надає інформація про сесії. 
  Даний компонент доступний тільки у [[yii\web\Application|веб додатках]].
  Більш детальна інформація наведена у розділі [Сесії і куки](runtime-sessions-cookies.md).
* [[yii\web\UrlManager|urlManager]]: використовується для розбору і побудови URL.
  Більш детальна інформація наведена у розділі [Маршрутизація та створення URL](runtime-routing.md).
* [[yii\web\User|user]]: являє собою інформацію авторизованого користувача.
  Даний компонент доступний тільки у [[yii\web\Application|веб додатках]].
  Більш детальна інформація наведена у розділі [Аутентифікація](security-authentication.md).
* [[yii\web\View|view]]: використовується для відображення представлень.
  Більш детальна інформація наведена у розділі [Представлення](structure-views.md).
