Автозавантаження класів
=======================

Пошук і підключення файлів класів в Yii реалізовано за допомогою
[автозавантаження класів](http://www.php.net/manual/ru/language.oop5.autoload.php).
Фреймворк надає власний швидкісний автозавантажувач, що сумісний з 
[PSR-4](https://github.com/php-fig/fig-standards/blob/master/proposed/psr-4-autoloader/psr-4-autoloader.md),
який встановлюється в момент підключення файлу `Yii.php`.

> Примітка: Для простоти опису, в цьому розділі ми будемо говорити тільки про автозавантаження класів.
Тим не менш, все описане також стосується до інтерфейсів і трейтів.


Використання автозавантажувача Yii <a name="using-yii-autoloader"></a>
----------------------------------

Для використання автозавантажувача класів Yii слід дотримуватися два простих правила створення і іменування класів:

* Кожен клас повинен належати простору імен (тобто `foo\bar\MyClass`)
* Кожен клас повинен знаходитися в окремому файлі, шлях до якого визначаться наступним правилом:

```php
// $className — це абсолютне імʼя класу, що починається з "\"
$classFile = Yii::getAlias('@' . str_replace('\\', '/', $className) . '.php');
```

Наприклад, якщо абсолютне імʼя класу `foo\bar\MyClass`, то [псевдонім шляху](concept-aliases.md) даного файлу класу буде
`@foo/bar/MyClass.php`. Для того, щоб даний псевдонім можна було перетворити в шлях до файлу, необхідно щоб або `@foo` 
або `@foo/bar` був [кореневим псевдонімом](concept-aliases.md#defining-aliases).

При використанні [базового шаблону додатка](start-installation.md) ви можете зберігати свої класи в просторі імен 
верхнього рівня `app`, щоб вони могли бути автоматично завантажені Yii без створення нового псевдоніма. 
Це працює, тому як `@app` є [заздалегідь визначеним псевдонімом](concept-aliases.md#predefined-aliases) і таке імʼя класу,
як `app\components\MyClass` відповідно до описаного вище алготімом перетвориться в шлях `AppBasePath/components/MyClass.php`.

У [розширеному шаблоні додатка](tutorial-advanced-app.md) кожен рівень додатку володіє власним кореневим псевдонімом. 
Наприклад, для frontend кореневим псевдонімом є `@frontend`, а для backend — `@backend`. Це дозволяє розмістити класи 
frontend в простір імен `frontend`, а класи backend в простір імен `backend`. При цьому класи будуть завантажені автоматично.


Мапа класів <a name="class-map"></a>
-----------

Автозавантажувач Yii підтримує *мапу класів*. Ця можливість дозволяє вказати шлях до файлу для кожного імені класу. 
При завантаженні класу автозавантажувач перевіряє наявність класу в мапі. Якщо він там є, відповідний файл буде завантажений 
безпосередньо без будь-яких додаткових перевірок. Це робить автозагрузку дуже швидкою. Всі класи самого фреймворка 
завантажуються саме цим способом.

Ви маєте можливість додати клас в мапу `Yii::$classMap` наступним чином:

```php
Yii::$classMap['foo\bar\MyClass'] = 'path/to/MyClass.php';
```

Для вказівки шляхів до файлів класів можна використовувати [псевдоніми](concept-aliases.md). Мапу класів необхідно сформувати
в процесі [первинного завантаження](runtime-bootstrapping.md), так як вона повинна бути сформована до використання класів.


Використання інших автозавантажувачів <a name="using-other-autoloaders"></a>
-------------------------------------

Оскільки Yii використовує Composer у якості менеджера залежностей, рекомендується додатково встановити його автозавантажувач.
Якщо ви використовуєте які-небудь сторонні бібліотеки із власними автозавантажувачами, то ці автозавантажувачі також необхідно 
встановити.

При використанні додаткових автозавантажувачів, файл `Yii.php` повинен бути підключений *після* їх установки. 
Це дозволить автозавантажувачу Yii першим намагатися завантажити клас. Наприклад, наведений нижче код взятий з
[вхідного скрипта](structure-entry-scripts.md) [базового шаблону додатка](start-installation.md). 
Перший рядок встановлює автозавантажувач Composer, а другий - автозавантажувач Yii:

```php
require(__DIR__ . '/../vendor/autoload.php');
require(__DIR__ . '/../vendor/yiisoft/yii2/Yii.php');
```

Ви можете використовувати автозавантажувач Composer без автозавантажувачa Yii, однак, швидкість автозавантаження в 
цьому випадку може зменшиться. До того ж вам буде необхідно слідувати правилам автозавантажувача Composer.

> Інформація: Якщо ви не хочете використовувати автозавантажувач Yii, створіть свою версію файлу `Yii.php`
  і підключіть його у [вхідному скрипті](structure-entry-scripts.md).


Автозавантаження класів розширень <a name="autoloading-extension-classes"></a>
---------------------------------

Автозавантажувач Yii може автоматично завантажувати класи [розширень](structure-extensions.md), при умові виконання вимоги
коректного визначення секції `autoload` у файлі `composer.json`. Більш докладно про це можна дізнатися з 
[офіційної документації Composer](https://getcomposer.org/doc/04-schema.md#autoload).

Якщо ви не використовуєте автозавантажувач Yii, то класи розширень можуть бути автоматично завантажені з допомогою автозавантажувач Composer.
