Автозагрузка классов
=================

Для подключения и загрузки классов в Yii используется [автозагрузка классов](http://www.php.net/manual/en/language.oop5.autoload.php). Автозагрузчик классов в Yii совместим со стандартом автозагрузки [PSR-4](https://github.com/php-fig/fig-standards/blob/master/proposed/psr-4-autoloader/psr-4-autoloader.md) и работает быстро.

Автозагрузчик устанавливается когда вы включаете файл `Yii.php` в свой скрипт.

> Примечание: Для простоты повествования мы будем говорить только об автозагрузке классов. Стоит отметить, что нижеприведенный способ может быть применен не только для автозагрузки классов, но и для автозагрузки интерфейсов(interface) и трейтов(traits).
  


Как использовать автозагрузчик Yii <a name="using-yii-autoloader"></a>
------------------------

Для того чтобы воспользоваться автозагрузчиком классов Yii вам нужно соблюсти два правила при создании и именовании классов:

* Каждый класс должен принадлежать определенному пространству имён  (прим. `foo\bar\MyClass`).
* Каждый класс должен находиться в отдельном файле, путь к которому будет определяться по следующему правилу:

```php
// $className - это полное имя класса, начинающееся с обратного слэша, т.е. \
$classFile = Yii::getAlias('@' . str_replace('\\', '/', $className) . '.php');
```

Например, если полное имя класса `foo\bar\MyClass`, то  [псевдоним пути(alias)](concept-aliases.md) данного файла будет 
`@foo/bar/MyClass.php`. Для того, чтобы данный псевдоним превратился в путь файла в файловой системе нужно чтобы либо `@foo` либо `@foo/bar` был [корневой ссылкой(root alias)](concept-aliases.md#defining-aliases).

При использовании [простого шаблона приложения (Basic Application Template)](start-basic.md), вы можете хранить свои классы в пространствах имен ниже `app`, тогда вам не понадобится указывать новый псевдоним пути для автозагрузки вашего класса. Это работает потому что
`@app` является [уже установленной ссылкой](concept-aliases.md#predefined-aliases), а такое имя класса как `app\components\MyClass`
преобразуется в путь 
`папкавашегоприложения/components/MyClass.php`.


В [шаблоне продвинутого приложения (Advanced Application Template)](tutorial-advanced-app.md), каждый уровень приложения обладает собственной корневой ссылкой. Например, для front-end части корневой ссылкой является `@frontend`, а для back-end части `@backend`. Это позволяет включать классы front-end части в пространство имен(namespace) ниже 'frontend', а для back-end части ниже 'backend'. При таком подходе ваши классы будут автоматически загружены автозагрузчиком Yii.


Карта классов <a name="class-map"></a>
---------

Автозагрузчик Yii обладает возможностью, которая называется *карта классов*.Эта возможность позволяет указывать где необходимо искать классы в зависимости от имени файла.
Прежде чем загрузить файл автозагрузчик проверяет есть ли правила для файла в карте классов. Если файл находится в карте классов, то данный файл будет загружен напрямую без дальнейших проверок.
Это позволяет существенно ускорить автозагрузку. Все базовые классы Yii загружаются именно этим способом.

Пример добавления класса в карту классов `Yii::$classMap`:

```php
Yii::$classMap['foo\bar\MyClass'] = 'path/to/MyClass.php';
```

[Ссылки](concept-aliases.md) могут быть использованы для указания пути к файлу класса. Карту классов необходимо указать в разделе [загрузки фреймворка](runtime-bootstrapping.md) т.к. карта должна быть создана до того, как будут использованы ваши классы.


Использование других автозагрузчиков <a name="using-other-autoloaders"></a>
-----------------------

По причине того что Yii использует Composer в качестве менеджера зависимостей, рекомендуется дополнительно установить автозагрузчик Composer. Если вы использует какие то дополнительные библиотеки, в которых есть свои автозагрузчики, то автозагрузчики этих библиотек также нужно будет установить.

В случаях использования дополнительных автозагрузчиков вместе с автозагрузчиком Yii, файл `Yii.php` должен быть подключен *после* установки всех дополнительных автозагрузчиков. В таком случае автозагрузчик Yii будет первым используемым автозагрузчиком из установленных при  автозагрузке. Например нижеследующий код взят напрямую из [входного скрипта(entry script)](structure-entry-scripts.md) для [Basic Application Template](start-basic.md). Первая строчка устанавливает автозагрузчик Composer, а вторая устанавливает автозагрузчик Yii.

```php
require(__DIR__ . '/../vendor/autoload.php');
require(__DIR__ . '/../vendor/yiisoft/yii2/Yii.php');
```

Вы можете использовать автозагрузчик Composer бес использования автозагрузчика Yii. Но в таком случае скорость автозагрузки может уменьшится, также вам нужно будет соблюсти правила автозагрузки для Composer.

> Информация: Если вы не хотите использовать автозагрузчик Yii, то вам нужно будет создать свою версию файла `Yii.php` 
   и подключить его к [входному скрипту(entry script)](structure-entry-scripts.md).


Автозагрузка классов расширений <a name="autoloading-extension-classes"></a>
-----------------------------

Автозагрузчик Yii позволяет автоматически загружать классы [расширений](structure-extensions.md). Единственное правило в таком случае - расширение должно правильно указывать раздел 'autoload' в своем файле 'composer.json'. Более подробную информацию о том как правильно  указать раздел 'autoload' вы можете узнать в [официальной документации Composer](https://getcomposer.org/doc/04-schema.md#autoload).

Если вы не используете автозагрузчик Yii, то классы расширений могут быть автоматически загружены с помощью автозагрузчика Composer.

