Guia Definitivo para Yii 2.0
============================
Esse tutorial está disponível sob os [termos da documentação do Yii](http://www.yiiframework.com/doc/terms/).


Todos os Direitos Reservados.

2014 (c) Yii Software LLC.


Introdução
----------

* [Sobre o Yii](intro-yii.md)
* [Migrando a partir da versão 1.1.*](intro-upgrade-from-v1.md)


Primeiros Passos
----------------

* [Instalando o Yii](start-installation.md)
* [Executando Aplicações](start-workflow.md)
* [Como Fazer um "Hello World"](start-hello.md)
* [Trabalhando com Formulários](start-forms.md)
* [Trabalhando com Banco de Dados](start-databases.md)
* [Gerando Código com Gii](start-gii.md)
* [Visão Geral](start-looking-head.md)


Estrutura de uma Aplicação
--------------------------

* [Visão Geral](structure-overview.md)
* [Scripts de Entrada](structure-entry-scripts.md)
* [Aplicações](structure-applications.md)
* [Componentes de Aplicação](structure-application-components.md)
* [Controllers (Controladores)](structure-controllers.md)
* [Models (Modelos)](structure-models.md)
* [Views (Visões)](structure-views.md)
* **TBD** [Filtros](structure-filters.md)
* **TBD** [Widgets](structure-widgets.md)
* **TBD** [Módulos](structure-modules.md)
* [Assets](structure-assets.md)
* **TBD** [Extensões](structure-extensions.md)


Tratamento de Requisições
-------------------------

* **TBD** [Bootstrapping](runtime-bootstrapping.md)
* **TBD** [Rotas](runtime-routing.md)
* **TBD** [Requisições](runtime-requests.md)
* **TBD** [Respostas](runtime-responses.md)
* **TBD** [Seções e Cookies](runtime-sessions-cookies.md)
* [Análise e Geração de URLs](runtime-url-handling.md)
* [Tratamento de Erros](runtime-handling-errors.md)
* [Gerenciamento de Logs](runtime-logging.md)


Conceitos Chaves
----------------

* [Componentes](concept-components.md)
* [Propriedades](concept-properties.md)
* [Eventos](concept-events.md)
* [Behaviors (Comportamentos)](concept-behaviors.md)
* [Configurações](concept-configurations.md)
* [Aliases](concept-aliases.md)
* [Autoloading de Classes](concept-autoloading.md)
* [Service Locator](concept-service-locator.md)
* [Injeção de Dependência](concept-di-container.md)


Trabalhando com Banco de Dados
------------------------------

* [Data Access Objects (DAO, Objeto de Acesso a Dados)](db-dao.md) - Estabelecendo uma conexão com o Banco de Dados, consultas básicas, transações e manipulação do esquema
* [Query Builder (Construtor de Consulta)](db-query-builder.md) - Consultando o banco de dados usando uma camada de abstração simples
* [Active Record](db-active-record.md) - Sobre "Active Record ORM" (Mapeamento Objeto-Relacional), recuperando e manipulando registros e definindo relacionamentos
* [Migrations (Migrações)](db-migrations.md) - Controle de versão do bancos de dados em um ambiente de desenvolvimento em equipe
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Coletando Dados de Usuários
---------------------------

* [Criando um Formulário](input-forms.md)
* [Validação de Dados](input-validation.md)
* **TBD** [Uploading de Arquivos](input-file-upload.md)
* **TBD** [Coletando Dados de Múltiplos Modelos](input-multiple-models.md)


Exibindo Dados
---------------

* **TBD** [Formatando Dados](output-formatting.md)
* **TBD** [Paginação](output-pagination.md)
* **TBD** [Ordenação](output-sorting.md)
* [Data Providers (Provedores de Dados)](output-data-providers.md)
* [Widgets de Dados](output-data-widgets.md)
* [Temas](output-theming.md)


Segurança
--------

* [Autenticação](security-authentication.md)
* [Autorização](security-authorization.md)
* [Trabalhando Com Senhas](security-passwords.md)
* **TBD** [Auth Clients](security-auth-clients.md)
* **TBD** [Melhores Práticas](security-best-practices.md)


Cache
-------

* [Visão Geral](caching-overview.md)
* [Cache de Dados](caching-data.md)
* [Cache de Fragmento](caching-fragment.md)
* [Cache de Página](caching-page.md)
* [Cache HTTP](caching-http.md)


Web Services com RESTful 
--------------------

* [Visão Inicial](rest-quick-start.md)
* [Recursos](rest-resources.md)
* [Controllers (Controladores)](rest-controllers.md)
* [Rotas](rest-routing.md)
* [Formatando Respostas](rest-response-formatting.md)
* [Autenticação](rest-authentication.md)
* [Rate Limiting](rest-rate-limiting.md)
* [Versionamento](rest-versioning.md)
* [Tratamento de Erros](rest-error-handling.md)


Ferramentas de Desenvolvimento
------------------------------

* [Barra de Ferramentas de Depuração e Depurador](tool-debugger.md)
* [Gerando Código usando o Gii](tool-gii.md)
* **TBD** [Gerando Documentação da API](tool-api-doc.md)


Testes
------

* [Visão Geral](test-overview.md)
* **TBD** [Testes Unitários](test-unit.md)
* **TBD** [Testes Funcionais](test-functional.md)
* **TBD** [Testes de Aceitação](test-acceptance.md)
* [Fixtures](test-fixtures.md)


Estendendo o Yii
----------------

* [Criando Extensões](extend-creating-extensions.md)
* [Customizando o Código do Núcleo](extend-customizing-core.md)
* [Usando Bibliotecas de Terceiros](extend-using-libs.md)
* **TBD** [Usando o Yii em Sistemas de Terceiros](extend-embedding-in-others.md)
* **TBD** [Usando Yii 1.1 e 2.0 juntos](extend-using-v1-v2.md)
* [Usando o Composer](extend-using-composer.md)


Tópicos Especiais
-----------------

* [Modelo de Aplicação Avançada](tutorial-advanced-app.md)
* [Construindo uma Aplicação a Partir do Zero](tutorial-start-from-scratch.md)
* [Comandos de Console](tutorial-console.md)
* [Ferramentas de Validação](tutorial-core-validators.md)
* [Internacionalização](tutorial-i18n.md)
* [Enviando E-mails](tutorial-mailing.md)
* [Ajustes no Desempenho](tutorial-performance-tuning.md)
* **TBD** [Ambiente de Hospedagem Compartilhada](tutorial-shared-hosting.md)
* [Ferramentas de Templates](tutorial-template-engines.md)


Widgets
-------

* GridView
* ListView
* DetailView
* ActiveForm
* Pjax
* Menu
* LinkPager
* LinkSorter
* [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)


Helpers
-------

* [Visão Geral](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)
