Looking Ahead
=============

If you've read through the entire "Getting Started" section, you have now created a complete Yii application. In the process, you have learned how to implement some commonly
needed features, such as getting data from users via an HTML form, fetching data from a database, and
displaying data in a paginated fashion. You have also learned how to use [Gii](tool-gii.md) to generate
code automatically. Using Gii for code generation turns the bulk of your Web development process into a task as simple as just filling out some forms. 

This section will summarize the Yii resources available to help you be more productive when using the framework.

* Documentation
    - The Definitive Guide:
      As the name indicates, the guide precisely defines how Yii should work and provides general guidance
      about using Yii. It is the single most important Yii tutorial, and one that you should read 
      before writing any Yii code.
    - The Class Reference:
      This specifies the usage of every class provided by Yii. It should be mainly used when you are writing
      code and want to understand the usage of a particular class, method, property. Usage of the class reference is best only after a contextual understanding of the entire framework.
    - The Wiki Articles:
      The wiki articles are written by Yii users based on their own experiences. Most of them are written
      like cookbook recipes, and show how to solve particular problems using Yii. While the quality of these
      articles may not be as good as the Definitive Guide, they are useful in that they cover broader topics
      and can often provide ready-to-use solutions.
    - Books
* [Extensions](http://www.yiiframework.com/extensions/):
  Yii boasts a library of thousands of user-contributed extensions that can be easily plugged into your applications, thereby making your application development even faster and easier.
* Community
    - [Forum](http://www.yiiframework.com/forum/)
    - [GitHub](https://github.com/yiisoft/yii2)
    - [Facebook](https://www.facebook.com/groups/yiitalk/)
    - [Twitter](https://twitter.com/yiiframework)
    - [LinkedIn](https://www.linkedin.com/groups/yii-framework-1483367)

