Псевдоніми
=========

Псевдоніми використовуються для позначення шляхів до файлів або URL адрес і допомагають уникнути використання абсолютних шляхів 
або URL в коді. Для того, щоб не переплутати псевдонім із звичайним шляхом до файлу або URL, він повинен починатися з `@`. В Yii 
є безліч заздалегідь визначених псевдонімів. Наприклад, `@yii` вказує на директорію, в яку був встановлений 
Yii framework, а `@web` можна використовувати для отримання базового URL поточного додатку.


Створення псевдонімів <a name="defining-aliases"></a>
----------------------------------------------

Для створення псевдоніма шляху до файлу або URL використовується метод [[Yii::setAlias()]]:

```php
// псевдонім шляху до файлу
Yii::setAlias('@foo', '/path/to/foo');

// псевдонім URL
Yii::setAlias('@bar', 'http://www.example.com');
```

> Примітка: псевдонім шляху до файлу або URL *не* обов'язково вказує на існуючий файл або ресурс.

Використовуючи вже заданий псевдонім, ви можете отримати на основі нього новий без виклику [[Yii :: setAlias ​​()]]. Зробити це можна, додавши в його кінець `/`, за яким слід один або більше сегментів шляху. Псевдоніми, визначені за допомогою
[[Yii::setAlias()]], є *кореневими псевдонімами*, в той час як отримані з них називаються похідними псевдонімами. На приклад, `@foo` є кореневим псевдонімом, а `@foo/bar/file.php` — похідним.

Ви можете задати новий псевдонім, використовуючи раніше створений псевдонім (не важливо, кореневої він чи похідний):

```php
Yii::setAlias('@foobar', '@foo/bar');
```

Кореневі псевдоніми, як правило, створюються на етапі [попереднього завантаження (bootstrapping)](runtime-bootstrapping.md).
Наприклад, ви можете викликати [[Yii::setAlias()]] у [вхідному скрипті](structure-entry-scripts.md). Для зручності, в
[додатку (Application)](structure-applications.md) передбачено властивість `aliases`, яке можна задати через
[конфігурацію додатку](concept-configurations.md):

```php
return [
    // ...
    'aliases' => [
        '@foo' => '/path/to/foo',
        '@bar' => 'http://www.example.com',
    ],
];
```


Перетворення псевдонімів <a name="resolving-aliases"></a>
----------------------------------------------------

Метод [[Yii :: getAlias ​​()]] перетворює кореневої псевдонім в шлях до файлу або URL, який цей псевдонім представляє. Цей же метод може працювати і з похідними псевдонімами:

```php
echo Yii::getAlias('@foo');               // виведе: /path/to/foo
echo Yii::getAlias('@bar');               // виведе: http://www.example.com
echo Yii::getAlias('@foo/bar/file.php');  // виведе: /path/to/foo/bar/file.php
```

Шлях або URL, представлений похідним псевдонімом, визначається шляхом заміни в ньому частині, що відповідає кореневого псевдоніму, на відповідний йому шлях або URL.

> Примітка: Метод [[Yii :: getAlias ​​()]] не перевіряє фактичного існування одержуваного шляху або URL.

Кореневої псевдонім може містити знаки '/'. При цьому метод [[Yii::getAlias()]] коректно визначить, яка частина псевдоніма є кореневої і вірно сформує шлях або URL:

```php
Yii::setAlias('@foo', '/path/to/foo');
Yii::setAlias('@foo/bar', '/path2/bar');
Yii::getAlias('@foo/test/file.php');  // виведе: /path/to/foo/test/file.php
Yii::getAlias('@foo/bar/file.php');   // виведе: /path2/bar/file.php
```

Якби `@foo/bar` не був оголошений кореневим псевдонімом, остання строка вивела б `/path/to/foo/bar/file.php`.

Використання псевдонімів. <a name="using-aliases"></a>
------------------------------------------------

Псевдоніми розпізнаються в багатьох частинах Yii без необхідності попередньо викликати [[Yii::getAlias()]] для отримання шляху або URL. Наприклад, [[yii\caching\FileCache::cachePath]] приймає як звичайний шлях до файлу, так і псевдонім шляху завдяки префіксу `@`, який дозволяє їх розрізняти.

```php
use yii\caching\FileCache;

$cache = new FileCache([
    'cachePath' => '@runtime/cache',
]);
```

Для того, щоб дізнатися чи підтримує метод або властивість псевдоніми, зверніться до документації API.


Заздалегідь визначені псевдоніми <a name="predefined-aliases"></a>
----------------------------------------------------------

В Yii заздалегідь визначені псевдоніми для часто використовуваних шляхів до файлів і URL:

- `@yii`: директорія, в якій знаходиться файл `BaseYii.php` (директорія фреймворка).
- `@app`: [[yii\base\Application::basePath|базовий шлях]] поточного додатку.
- `@runtime`: [[yii\base\Application::runtimePath|директорія runtime]] поточного додатку.
- `@vendor`: [[yii\base\Application::vendorPath|директорія vendor Composer].
- `@webroot`: вебрут поточного веб додатка (там де `index.php`).
- `@web`: базовий URL поточного додатку.

Псевдонім `@yii` задається в момент підключення файлу `Yii.php` у [вхідному скрипті](structure-entry-scripts.md).
Решта псевдоніми задаються в конструкторі додатки в момент застосування [конфигурації](concept-configurations.md).


Псевдоніми розширень <a name="extension-aliases"></a>
------------------------------------------------

Для кожного [розширення](structure-extensions.md), встановлюваного через Composer, автоматично задається псевдонім. 
Його ім'я відповідає кореневого простору імен розширення відповідно до його `composer.json`. Псевдонім представляє 
шлях до кореневої директорії пакета. Наприклад, якщо ви встановите розширення `yiisoft/yii2-jui`, то вам автоматично стане доступний псевдонім `@yii/jui`. Він створюється на етапі [первинного завантаження (bootstrapping)](runtime-bootstrapping.md)
приблизно так:

```php
Yii::setAlias('@yii/jui', 'VendorPath/yiisoft/yii2-jui');
```
