デバッグツールバーとデバッガ
============================

> Note|注意: この節はまだ執筆中です。

Yii2 には、アプリケーションの迅速な開発とデバッグのために、便利なツールバーと内蔵のデバッガが付いています。
ツールバーは現在開かれているページに関する情報を表示します。
そして、デバッガはそれまでに収集したデータを分析する (すなわち、変数の値を確認する) のに使用できます。

これらのツールは、特別な設定をしなくても、次のことを可能にしてくれます。

- フレームワークのバージョン、PHP バージョン、レスポンスステータス、現在のコントローラとアクション、パフォーマンス情報、その他をツールバーによって素速く取得
- アプリケーションと PHP の構成の閲覧
- リクエストデータ、リクエストとレスポンスのヘッダ、セッションデータ、そして環境変数の閲覧
- ログの閲覧、検索、フィルタリング
- プロファイリング結果の閲覧
- ページによって実行されたデータベースクエリの閲覧
- アプリケーションから送信されたメールの閲覧

これらの情報の全てはリクエストごとに閲覧できますが、過去のリクエストに遡って情報を閲覧することも可能です。


インストールと構成
------------------

これらの機能を有効にするためには、構成情報ファイルに以下の行を追加してデバッグモジュールを有効にします。

```php
'bootstrap' => ['debug'],
'modules' => [
    'debug' => 'yii\debug\Module',
]
```

デフォルトでは、デバッグモジュールはウェブサイトをローカルホストから閲覧した場合にだけ動作します。
これをリモートサーバ (ステージングサーバ) で使いたい場合は、パラメータ `allowedIPs` を構成情報に追加して、あなたの IP をホワイトリストに加えてください。

```php
'bootstrap' => ['debug'],
'modules' => [
    'debug' => [
        'class' => 'yii\debug\Module',
        'allowedIPs' => ['1.2.3.4', '127.0.0.1', '::1']
    ]
]
```

URL マネージャで `enableStrictParsing` オプションを使っている場合は、`rules` に次の行を追加してください。

```php
'urlManager' => [
    'enableStrictParsing' => true,
    'rules' => [
        // ...
        'debug/<controller>/<action>' => 'debug/<controller>/<action>',
    ],
],
```

> Note|注意: デバッガは各リクエストに関する情報を `@runtime/debug` ディレクトリに保存します。
> デバッガを使用するのに問題が生じたとき、例えば、デバッガを使おうとするとおかしなエラーメッセージが出たり、ツールバーが表示されなかったり、何も結果が表示されなかったりしたときは、ウェブサーバがこのディレクトリとその中に置かれるファイルに対して十分なアクセス権限を持っているかどうかを確認してください。


### ロギングとプロファイリングのための追加の構成

ロギングとプロファイリングは、フレームワークとアプリケーションの両方の実行フローを理解するのを助けてくれる、単純ながら強力なツールです。これらのツールは、開発環境でも本番環境でも役に立ちます。

本番環境では、[ロギング](logging.md) のガイドの節で説明されているように、著しく重要なメッセージを手動でログに取るだけにとどめるべきです。
本番環境で全てのメッセージをログに取り続けるのは、パフォーマンスへの損害が大きすぎます。

開発環境では、ログは多く取れば取るほど良いでしょう。とりわけ、実行トレースの記録は有用です。

フレームワークのフードの下で何が起っているかを理解する手助けとなるトレースメッセージを見るためには、構成情報ファイルでトレースレベルを設定する必要があります。

```php
return [
    // ...
    'components' => [
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0, // <-- ここ
```

デフォルトでは、Yii がデバッグモードで走っている場合のトレースレベルは自動的に `3` に設定されます。
デバッグモードは `index.php` ファイルに次の行が存在することによって決定されます。

```php
defined('YII_DEBUG') or define('YII_DEBUG', true);
```

> Note|注意: デバッグモードはパフォーマンスに著しい悪影響を及ぼし得ますので、本番環境では必ずデバッグモードを無効にしてください。
更に、デバッグモードは公開すべきでない情報をエンドユーザに曝露することがあり得ます。


あなた自身のパネルを作る
------------------------

ツールバーとデバッガは、ともに、高い構成可能性とカスタマイズ性を持っています。
あなた自身のパネルを作成して、あなたが必要とする特定のデータを収集して表示することも出来ます。
以下において、簡単なカスタムパネルを作るプロセスを説明します。このパネルは以下の機能を持つものとします。

- リクエストの間にレンダリングされたビューを収集する
- ツールバーにレンダリングされたビューの数を表示する
- デバッガでビューの名前を確認することが出来る

ベーシックアプリケーションテンプレートを使用しているものと仮定します。

最初に、`panels/ViewsPanel.php` で `Panel` クラスを実装する必要があります。

```php
<?php
namespace app\panels;

use yii\base\Event;
use yii\base\View;
use yii\base\ViewEvent;
use yii\debug\Panel;


class ViewsPanel extends Panel
{
    private $_viewFiles = [];

    public function init()
    {
        parent::init();
        Event::on(View::className(), View::EVENT_BEFORE_RENDER, function (ViewEvent $event) {
            $this->_viewFiles[] = $event->sender->getViewFile();
        });
    }


    /**
     * @inheritdoc
     */
    public function getName()
    {
        return 'Views';
    }

    /**
     * @inheritdoc
     */
    public function getSummary()
    {
        $url = $this->getUrl();
        $count = count($this->data);
        return "<div class=\"yii-debug-toolbar-block\"><a href=\"$url\">ビュー数 <span class=\"label\">$count</span></a></div>";
    }

    /**
     * @inheritdoc
     */
    public function getDetail()
    {
        return '<ol><li>' . implode('<li>', $this->data) . '</ol>';
    }

    /**
     * @inheritdoc
     */
    public function save()
    {
        return $this->_viewFiles;
    }
}
```

上記のコードのワークフローは以下のとおりです。

1. 全てのコントローラのアクションが走る前に `init` が実行されます。
   コントローラのアクションが実行される間にデータを収集するハンドラをアタッチするには、このメソッドが最適の場所です。
2. コントローラのアクションが実行された後に `save` が呼ばれます。
   このメソッドによって返されたデータは、データファイルに保存されます。
   このメソッドが何も返さなかった場合には、パネルは表示されません。
3. データファイルからのデータは `$this->data` にロードされます。
   ツールバーの場合は、これは常に最新のデータを表します。
   デバッガの場合は、このプロパティを以前のデータファイルから読み出すようにセットされることもあります。
4. ツールバーはその内容を `getSummary` から取得します。
   そこではレンダリングされたビューの数を表示します。
   デバッガは同じ目的のために `getDetail` を使用します。

さあ、それでは、デバッガに新しいパネルを使うように教えましょう。
`config/web.php` で、デバッガの構成を次のように変更します。

```php
if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        'panels' => [
            'views' => ['class' => 'app\panels\ViewsPanel'],
        ],
    ];

// ...
```

以上です。これで、たいしてコードを書くこともなく、もう一つの便利なパネルを手に入れました。
