あなた自身のアプリケーション構造を作成する
==========================================

> Note|注意: この節はまだ執筆中です。

[ベーシック](https://github.com/yiisoft/yii2/tree/master/apps/basic) と [アドバンスト](https://github.com/yiisoft/yii2/tree/master/apps/advanced) のアプリケーションテンプレートは、あなたの要求をほとんどカバーする優れたものですが、あなたのプロジェクトを開始するためのあなた自身のテンプレートを作成したいこともあるでしょう。

Yii におけるアプリケーションテンプレートは、`composer.json` ファイルを含み、Composer パッケージとして登録されたレポジトリであるに過ぎません。
どのようなレポジトリでも、Composer パッケージとして特定し、`create-project` Composer コマンドによってインストール可能なものとすることが可能です。

テンプレート全体を最初から構築するのは少々大変ですので、内蔵のテンプレートの一つを基礎として使うのが良いでしょう。
ここでは、ベーシックテンプレートを使いましょう。

ベーシックテンプレートをクローンする
------------------------------------

最初のステップは、ベーシック Yii テンプレートの Git レポジトリをクローンすることです。

```bash
git clone git@github.com:yiisoft/yii2-app-basic.git
```

そして、レポジトリがあなたのコンピュータにダウンロードされるのを待ちます。
テンプレートに加えた変更はプッシュバックされませんので、ダウンロードしたものから `.git` ディレクトリとその中身を全て削除して構いません。

ファイルを修正する
------------------

次に、あなたのテンプレートに合うように `composer.json` を修正します。
`name`、`description`、`keywords`、`homepage`、`license` および `support` の値を、あなたの新しいテンプレートを説明するものに変更します。
また、`require`、`require-dev`、`suggest` や、その他のオプションも、あなたのテンプレートの要求に合うように調整します。

> Note|注意: `composer.json` ファイルで、`extra` の下の `writable` パラメータを使って、アプリケーションがテンプレートを使って作成された後に設定すべきファイル単位のアクセス権限を指定してください。

次に、あなたがデフォルトとしたいと思うように、アプリケーションの構造と内容を実際に修正します。
最後に、あなたのテンプレートに適用できるように、README ファイルを更新します。

パッケージを作る
----------------

テンプレートが定義できたら、それを基に Git レポジトリを作成して、ファイルをそこにプッシュします。
あなたのテンプレートをオープンソース化するつもりなら、レポジトリをホストするのには [Github](http://github.com) が最適の場所です。
テンプレートを共同作業に使わないつもりであれば、どんな Git レポジトリサイトでも構いません。

次に、Composer のためにパッケージを登録する必要があります。
パブリックなテンプレートであれば、パッケージは [Packagist](https://packagist.org/) に登録すべきです。
プライベートなテンプレートは、パッケージの登録が少々トリッキーです。
その説明については [Composer ドキュメント](https://getcomposer.org/doc/05-repositories.md#hosting-your-own) を参照してください。

テンプレートを使う
------------------

Yii の新しいアプリケーションテンプレートを作成するのに必要なことは以上です。
これで、あなたのテンプレートを使ってプロジェクトを作成することが出来ます。

```
composer global require "fxp/composer-asset-plugin:1.0.0-beta4"
composer create-project --prefer-dist --stability=dev mysoft/yii2-app-coolone new-project
```
